//+------------------------------------------------------------------+
//+------------------------------------------------------------------+"
//----
#property indicator_separate_window
#property indicator_buffers 4
#property indicator_color2 DodgerBlue
#property indicator_color3 Tomato
#property indicator_width2 4
#property indicator_width3 4
//----
int   LeftNum1=56;
int   LeftNum2=56;
//----
extern int     RangePeriods=55;
extern double  PriceSmoothing=0.03;
extern double  IndexSmoothing=0.00;
extern int Left_Right=0; 
extern int Up_Down   = 0; 
string         ThisName="";
int            DrawStart;
int k;
//---- buffers
double ExtMapBuffer1[];
double ExtMapBuffer2[];
double ExtMapBuffer3[];
double ExtMapBuffer4[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   IndicatorBuffers(4);
   SetIndexStyle(0,DRAW_NONE);
   SetIndexBuffer(0,ExtMapBuffer1);
   SetIndexStyle(1,DRAW_HISTOGRAM);
   SetIndexBuffer(1,ExtMapBuffer2);
   SetIndexStyle(2,DRAW_HISTOGRAM);
   SetIndexBuffer(2,ExtMapBuffer3);
   SetIndexStyle(3,DRAW_NONE);
   SetIndexBuffer(3,ExtMapBuffer4);
//----
   string Text=ThisName;
   Text=Text+"  (rPeriods "+RangePeriods;
   Text=Text+", pSmooth "+DoubleToStr(PriceSmoothing,2);
   Text=Text+", iSmooth "+DoubleToStr(IndexSmoothing,2);
   Text=Text+")  ";
   IndicatorShortName(Text);
   SetIndexLabel(1,NULL);
   SetIndexLabel(2,NULL);
   DrawStart=2*RangePeriods+4;             // DrawStart= BarNumber calculated from left to right
   SetIndexDrawBegin(1,DrawStart);
   SetIndexDrawBegin(2,DrawStart);
//----
   if (PriceSmoothing>=1.0)
     {
      PriceSmoothing=0.9999;
      Alert("PriceSmothing factor has to be smaller 1!");
     }
   if (PriceSmoothing<0)
     {
      PriceSmoothing=0;
      Alert("PriceSmothing factor mustn''t be negative!");
     }
   if (IndexSmoothing>=1.0)
     {
      IndexSmoothing=0.9999;
      Alert("PriceSmothing factor has to be smaller 1!");
     }
   if (IndexSmoothing<0)
     {
      IndexSmoothing=0;
      Alert("PriceSmothing factor mustn''t be negative!");
     }
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   if (Bars<DrawStart)
     {
      Alert("Not enough Bars loaded to calculate FisherIndicator with RangePeriods=",RangePeriods);
      return(-1);
     }
//----   
   int    counted_bars=IndicatorCounted();
   if (counted_bars<0) return(-1);
   if (counted_bars>0) counted_bars--;
   double  LowestLow, HighestHigh, GreatestRange, MidPrice;
   double  PriceLocation, SmoothedLocation, FishIndex, SmoothedFish;
//----
   int pos=Bars-counted_bars ;
  // k=pos;
         // Position = BarPosition calculated from right to left
   int LeftNum1=Bars-pos;            // when more bars are loaded the Position of a bar changes but not its LeftNum
   if (LeftNum1<RangePeriods+1) { pos=Bars-RangePeriods-1;  }
//----
   while(pos>=0)
     { 
       LowestLow=Low[Lowest(NULL,0,MODE_LOW,RangePeriods,pos)];
   HighestHigh=High[Highest(NULL,0,MODE_HIGH,RangePeriods,pos)];
   if (HighestHigh-LowestLow<0.1*Point)HighestHigh=LowestLow+0.1*Point;
   GreatestRange=HighestHigh-LowestLow;
   MidPrice=(High[pos]+Low[pos])/2;
    k=pos+Left_Right; 
   // PriceLocation in current Range 
   if (GreatestRange!=0)
     {
      PriceLocation=(MidPrice-LowestLow)/GreatestRange;
      PriceLocation= 2.0*PriceLocation - 1.0;           // ->  -1 < PriceLocation < +1
     }
   // Smoothing of PriceLocation
   ExtMapBuffer4[k]=PriceSmoothing*ExtMapBuffer4[k+1]+(1.0-PriceSmoothing)*PriceLocation;
   SmoothedLocation=ExtMapBuffer4[k];
   if (SmoothedLocation> 0.99) SmoothedLocation= 0.99; // verhindert, dass MathLog unendlich wird
   if (SmoothedLocation<-0.99) SmoothedLocation=-0.99; // verhindert, dass MathLog minuns unendlich wird

   if(1-SmoothedLocation!=0) FishIndex=MathLog((1+SmoothedLocation)/(1-SmoothedLocation));
   else Alert("Unerlaubter Zustand bei Bar Nummer ",Bars-(k));

   ExtMapBuffer1[k]=IndexSmoothing*ExtMapBuffer1[k+1]+(1.0-IndexSmoothing)*FishIndex;
   if (Bars-pos<DrawStart)ExtMapBuffer1[k]=0;
   SmoothedFish=ExtMapBuffer1[k];
//----
   if (SmoothedFish>0)     // up trend
     {
      ExtMapBuffer2[k]=SmoothedFish;
      ExtMapBuffer3[k]=0;
     }
   else                          // else down trend
     {
      ExtMapBuffer2[k]=0;
      ExtMapBuffer3[k]=SmoothedFish;
     }
//----
      pos--       ;
     }
//----
   return(0);
  }
//+------------------------------------------------------------------+

